//
//  RMFTP-Constants.h
//  RMFTP
//
//  Created by Keith Duncan on 22/05/2013.
//  Copyright (c) 2013 Realmac Software. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, RMCurlConnectionType) {
    RMCurlConnectionTypeLocalFolder = 0,
    RMCurlConnectionTypeFTP = 1,
    RMCurlConnectionTypeSFTP = 2,
    RMCurlConnectionTypeFTP_StartTLS = 3,
    RMCurlConnectionTypeS3 = 4,
};

typedef NS_ENUM(NSInteger, RMCurlURLConnectionMode) {
	RMCurlURLConnectionModeExtendedPassive = 0,
	RMCurlURLConnectionModePassive = 1,
	RMCurlURLConnectionModeActive = 2,
};

typedef NS_ENUM(NSInteger, RMCurlVerifyHost) {
    RMCurlVerifyHostNone = 0,
    RMCurlVerifyHostExists = 1,
    RMCurlVerifyHostMatches = 2,
};

typedef NS_ENUM(NSInteger, RMCurlSSLMode) {
    RMCurlSSLModeNone = 0,
    RMCurlSSLModeTry = 1,
    RMCurlSSLModeControl = 2,
    RMCurlSSLModeAll = 3,
};

typedef NS_ENUM(NSInteger, RMCurlDirectoryCreationMode) {
    RMCurlDirectoryCreationModeNone = 0,
    RMCurlDirectoryCreationModeCreate = 1,
    RMCurlDirectoryCreationModeCreateRetry = 2,
};

typedef NS_ENUM(NSInteger, RMCurlURLConnectionErrorCode) {
	RMCurlURLConnectionErrorCodeUnknown = 0,
	
	/* Authentication [-100, -199] */
	RMCurlURLConnectionErrorCodeInvalidCredentials = -100,
	
	/* Configuration [-200, -299] */
    RMCurlURLConnectionErrorCodeInvalidHostname = -201,
    RMCurlURLConnectionErrorCodeWeirdServerReply = -202,
};

extern NSString *const RMFTPBundleIdentifier;
extern NSString *const RMCurlURLConnectionErrorDomain;
extern NSString *const RMCurlErrorDomain;

extern NSString *const RMCurlURLConnectionDefaultsVerboseKey;


typedef void (^RMNetworkClientProgressBlock)(double totalBytesToDownload, double bytesDownloaded, double totalBytesToUpload, double bytesUploaded);

typedef void (^RMCurlFileUploadCompletedBlock)(NSError *error, NSString *path);




